* Uniquely identify age and gender groups
gen ageracegroup = ${numage}*(racegroup-1) + agegroup
global numagerace = ${numage} * ${numrace}
# delimit ;
label define ageracegroups 
	1 "White, 25-34" 
	2 "White, 35-44" 
	3 "White, 45-54" 
	4 "White, 55-64"
	5 "Black, 25-34" 
	6 "Black, 35-44" 
	7 "Black, 45-54" 
	8 "Black, 55-64"	
	9 "Hispanic, 25-34" 
	10 "Hispanic, 35-44" 
	11 "Hispanic, 45-54" 
	12 "Hispanic, 55-64"
	13 "Other, 25-34" 
	14 "Other, 35-44" 
	15 "Other, 45-54" 
	16 "Other, 55-64"	
	,replace
	;
label values ageracegroup ageracegroups;
# delimit cr

* Uniquely identify age and gender groups
gen agegendergroup = ${numage}*(gendergroup-1) + agegroup
global numagegender = ${numage} * ${numgender}
# delimit ;
label define agegendergroups 
	1 "Male, 25-34" 
	2 "Male, 35-44" 
	3 "Male, 45-54" 
	4 "Male, 55-64"
	5 "Female, 25-34" 
	6 "Female, 35-44" 
	7 "Female, 45-54" 
	8 "Female, 55-64"

	,replace
	;
label values agegendergroup agegendergroups;
# delimit cr

* Race Groups
* White= 1, Black = 2, Hispanic = 3, Other = 4
# delimit
label define racegroups
	1 "White"
	2 "Black"
	3 "Hispanic"
	4 "Other"
	,replace
;
label values racegroup racegroups;
# delimit cr

* Uniquely identify race and gender groups
gen racegendergroup = ${numrace}*(gendergroup-1) + racegroup
global numracegender = ${numrace} * ${numgender}
# delimit ;
label define racegendergroups 
	1 "Male, White" 
	2 "Male, Black" 
	3 "Male, Hispanic" 
	4 "Male, Other"
	5 "Female, White" 
	6 "Female, Black" 
	7 "Female, Hispanic" 
	8 "Female, Other" 
	,replace
	;
label values racegendergroup racegendergroups;
# delimit cr


* Generate Age/gender/Race Groups
gen agegenderracegroup = ${numrace}*(agegendergroup-1) + racegroup
global numagegenderrace = ${numrace}*${numagegender}
# delimit ;
label define agegenderracegroups 
	1 "Male, 25-34, White"
	2 "Male, 25-34, Black"
	3 "Male, 25-34, Hispanic"
	4 "Male, 25-34, Other"
	5 "Male, 35-44, White"
	6 "Male, 35-44, Black"
	7 "Male, 35-44, Hispanic"
	8 "Male, 35-44, Other"
	9 "Male, 45-54, White"
	10 "Male, 45-54, Black"
	11 "Male, 45-54, Hispanic"
	12 "Male, 45-54, Other"
	13 "Male, 55-64, White"
	14 "Male, 55-64, Black"
	15 "Male, 55-64, Hispanic"
	16 "Male, 55-64, Other"
	17 "Female, 25-34, White"
	18 "Female, 25-34, Black"
	19 "Female, 25-34, Hispanic"
	20 "Female, 25-34, Other"
	21 "Female, 35-44, White"
	22 "Female, 35-44, Black"
	23 "Female, 35-44, Hispanic"
	24 "Female, 35-44, Other"
	25 "Female, 45-54, White"
	26 "Female, 45-54, Black"
	27 "Female, 45-54, Hispanic"
	28 "Female, 45-54, Other"
	29 "Female, 55-64, White"
	30 "Female, 55-64, Black"
	31 "Female, 55-64, Hispanic"
	32 "Female, 55-64, Other"
	,replace
	;
label values agegenderracegroup agegenderracegroups;
# delimit cr

/*
* Work hours Groups
global numwork = 2

# delimit
label define workgroups
	1 "Full Time"
	2 "Part Time"
	,replace
;
label values workgroup workgroups;
# delimit cr


* Uniquely identify grace and work groups
gen raceworkgroup = ${numrace}*(workgroup-1) + racegroup
global numracework = ${numrace} * ${numwork}
# delimit ;
label define raceworkgroups 
	1 "Full Time, White" 
	2 "Full Time, Black" 
	3 "Full Time, Hispanic" 
	4 "Full Time, Other"
	5 "Part Time, White" 
	6 "Part Time, Black" 
	7 "Part Time, Hispanic" 
	8 "Part Time, Other" 
	,replace
	;
label values raceworkgroup raceworkgroups;
# delimit cr


* Uniquely identify gender and work groups
gen genderworkgroup = ${numgender}*(workgroup-1) + gendergroup
global numgenderwork = ${numgender} * ${numwork}
# delimit ;
label define genderworkgroups 
	1 "Full Time, M" 
	2 "Full Time, F" 
	3 "Part Time, M" 
	4 "Part Time, F" 
	,replace
	;
label values genderworkgroup genderworkgroups;
# delimit cr


* Generate Work/gender/Race Groups
gen workgenderracegroup = ${numrace}*(genderworkgroup-1) + racegroup
global numworkgenderrace = ${numrace}*${numgenderwork}
# delimit ;
label define workgenderracegroups 
	1 "Male, Full Time, White"
	2 "Male, Full Time, Black"
	3 "Male, Full Time, Hispanic"
	4 "Male, Full Time, Other"
	5 "Male, Part Time, White"
	6 "Male, Part Time, Black"
	7 "Male, Part Time, Hispanic"
	8 "Male, Part Time, Other"
	9 "Female, Full Time, White"
	10 "Female, Full Time, Black"
	11 "Female, Full Time, Hispanic"
	12 "Female, Full Time, Other"
	13 "Female, Part Time, White"
	14 "Female, Part Time, Black"
	15 "Female, Part Time, Hispanic"
	16 "Female, Part Time, Other"
	,replace
	;
label values workgenderracegroup workgenderracegroups;
# delimit cr
*/

* Rural Urban Groups
# delimit
label define metgroups
	1 "Urban"
	2 "Rural"
	,replace
;
label values metgroup metgroups;
# delimit cr

* Uniquely identify grace and met groups
gen racemetgroup = ${numrace}*(metgroup-1) + racegroup
global numracemet = ${numrace} * ${nummet}
# delimit ;
label define racemetgroups 
	1 "Urban, White" 
	2 "Urban, Black" 
	3 "Urban, Hispanic" 
	4 "Urban, Other"
	5 "Rural, White" 
	6 "Rural, Black" 
	7 "Rural, Hispanic" 
	8 "Rural, Other" 
	,replace
	;
label values racemetgroup racemetgroups;
# delimit cr


* Uniquely identify gender and met groups
gen gendermetgroup = ${numgender}*(metgroup-1) + gendergroup
global numgendermet = ${numgender} * ${nummet}
# delimit ;
label define gendermetgroups 
	1 "Urban, Male" 
	2 "Urban, Female" 
	3 "Rural, Male" 
	4 "Rural, Female" 
	,replace
	;
label values gendermetgroup gendermetgroups;
# delimit cr

* Uniquely identify age and met groups
gen agemetgroup = ${numage}*(metgroup-1) + agegroup
global numagemet = ${numage} * ${nummet}
# delimit ;
label define agemetgroups 
	1 "Urban, 25-34" 
	2 "Urban, 35-44" 
	3 "Urban, 45-54" 
	4 "Urban, 55-64"
	5 "Rural, 25-34" 
	6 "Rural, 35-44" 
	7 "Rural, 45-54" 
	8 "Rural, 55-64"	
	,replace
	;
label values agemetgroup agemetgroups;
# delimit cr


* Generate met/gender/Race Groups
gen metgenderracegroup = ${numrace}*(gendermetgroup-1) + racegroup
global nummetgenderrace = ${numrace}*${numgendermet}
# delimit ;
label define metgenderracegroups 
	1 "Male, Urban, White"
	2 "Male, Urban, Black"
	3 "Male, Urban, Hispanic"
	4 "Male, Urban, Other"
	5 "Male, Rural, White"
	6 "Male, Rural, Black"
	7 "Male, Rural, Hispanic"
	8 "Male, Rural, Other"
	9 "Female, Urban, White"
	10 "Female, Urban, Black"
	11 "Female, Urban, Hispanic"
	12 "Female, Urban, Other"
	13 "Female, Rural, White"
	14 "Female, Rural, Black"
	15 "Female, Rural, Hispanic"
	16 "Female, Rural, Other"
	,replace
	;
label values metgenderracegroup metgenderracegroups;
# delimit cr



* Generate met/gender/age Groups
gen agegendermetgroup = ${numage}*(gendermetgroup-1) + agegroup
global numagegendermet = ${numage}*${numgendermet}
# delimit ;
label define agegendermetgroups 
	1 "Male, Urban, 25-34"
	2 "Male, Urban, 35-44"
	3 "Male, Urban, 45-54"
	4 "Male, Urban, 55-64"
	5 "Male, Rural, 25-34"
	6 "Male, Rural, 35-44"
	7 "Male, Rural, 45-54"
	8 "Male, Rural, 55-64"
	9 "Female, Urban, 25-34"
	10 "Female, Urban, 35-44"
	11 "Female, Urban, 45-54"
	12 "Female, Urban, 55-64"
	13 "Female, Rural, 25-34"
	14 "Female, Rural, 35-44"
	15 "Female, Rural, 45-54"
	16 "Female, Rural, 55-64"
	,replace
	;
label values agegendermetgroup agegendermetgroups;
# delimit cr
